package com.company.tp07_01_localtodoapp.repository;

import android.app.Application;
import android.os.AsyncTask;

import androidx.lifecycle.LiveData;

import com.company.tp07_01_localtodoapp.database.Todo;
import com.company.tp07_01_localtodoapp.database.TodoDao;
import com.company.tp07_01_localtodoapp.database.TodoRoomDatabase;

import java.util.List;

public class TodoRepo {
    private TodoDao todoDao;
    private LiveData<List<Todo>> todoList;
    private static TodoRepo instance;

    public static TodoRepo getInstance(Application application){
        if(instance==null){
            instance = new TodoRepo(application);
        }
        return instance;
    }

    private TodoRepo(Application application) {
        TodoRoomDatabase db = TodoRoomDatabase.getInstance(application);
        todoDao = db.todoDao();
        todoList = todoDao.getTodoList();
    }
    public LiveData<List<Todo>> getTodoList() {
        return todoList;
    }

    public void insert (Todo todo) {
        new insertAsyncTask(todoDao).execute(todo);
    }
    private static class insertAsyncTask extends AsyncTask<Todo, Void, Void> {

        private TodoDao mAsyncTodoDao;

        insertAsyncTask(TodoDao dao) {
            mAsyncTodoDao = dao;
        }
        @Override
        protected Void doInBackground(final Todo... params) {
            mAsyncTodoDao.insert(params[0]);
            return null;
        }
    }
}
